/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.syntax;

import javax.swing.text.Segment;
import replicatorg.app.syntax.Token;

public abstract class TokenMarker {
    protected Token firstToken;
    protected Token lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;

    public Token markTokens(Segment line, int lineIndex) {
        byte token;
        if (lineIndex >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + lineIndex);
        }
        this.lastToken = null;
        LineInfo info = this.lineInfo[lineIndex];
        LineInfo prev = lineIndex == 0 ? null : this.lineInfo[lineIndex - 1];
        byte oldToken = info.token;
        info.token = token = this.markTokensImpl(prev == null ? (byte)0 : prev.token, line, lineIndex);
        if (this.lastLine != lineIndex || !this.nextLineRequested) {
            this.nextLineRequested = oldToken != token;
        }
        this.lastLine = lineIndex;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    public boolean supportsMultilineTokens() {
        return true;
    }

    public void insertLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        this.length += lines;
        this.ensureCapacity(this.length);
        int len = index + lines;
        System.arraycopy(this.lineInfo, index, this.lineInfo, len, this.lineInfo.length - len);
        int i = index + lines - 1;
        while (i >= index) {
            this.lineInfo[i] = new LineInfo();
            --i;
        }
    }

    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.lineInfo, len, this.lineInfo, index, this.lineInfo.length - len);
    }

    public int getLineCount() {
        return this.length;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    protected TokenMarker() {
    }

    protected void ensureCapacity(int index) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[index + 1];
        } else if (this.lineInfo.length <= index) {
            LineInfo[] lineInfoN = new LineInfo[(index + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoN, 0, this.lineInfo.length);
            this.lineInfo = lineInfoN;
        }
    }

    protected void addToken(int length, byte id) {
        if (id >= 100 && id <= 126) {
            throw new InternalError("Invalid id: " + id);
        }
        try {
            if (length == 0 && id != 127) {
                return;
            }
            if (this.firstToken == null) {
                this.lastToken = this.firstToken = new Token(length, id);
            } else if (this.lastToken == null) {
                this.lastToken = this.firstToken;
                this.firstToken.length = length;
                this.firstToken.id = id;
            } else if (this.lastToken.next == null) {
                this.lastToken = this.lastToken.next = new Token(length, id);
            } else {
                this.lastToken = this.lastToken.next;
                this.lastToken.length = length;
                this.lastToken.id = id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte token, Object obj) {
            this.token = token;
            this.obj = obj;
        }
    }
}

